function [pb_corrected_fpiR] = ransac_plane_fit_fpi(bfr_plane_coeff,x_fpiR,y_fpiR,fpiR_crop)
% Plane fitted to the corresponding breech face region is subtracted from
% the firing pin impression

%% input
% bfr_plane_coeff : coefficients of the plane fitted to the breech face
%                   region
% x_fpiR : the x values of the tightly cropped registered/unregistered
%          firing pin impression
% y_fpiR : the y values of the tightly cropped registered/unregistered
%          firing pin impression
% fpiR_crop : the tightly cropped registered/unregistered firing pin impression

%% output
% pb_corrected_fpiR : planar bias corrected registered/unregistered firing
%                     pin impression

[rr cc]=size(fpiR_crop);
BD=fpiR_crop;
BDZ=BD;
BDZ(BDZ==0)=NaN;
Xx2n=x_fpiR.*ones([1 cc]);
Yy2n=y_fpiR.*ones([rr 1]);

XTn=reshape(Xx2n,[rr*cc 1]);
YTn=reshape(Yy2n,[rr*cc 1]);
ZTn=reshape(fpiR_crop,[rr*cc 1]);
Full_img=[XTn YTn ZTn];

XYZ3=Full_img;
XYZ=XYZ3';

TU=XYZ3;

Z1=-(((bfr_plane_coeff(1)/bfr_plane_coeff(3))*TU(:,1))+(bfr_plane_coeff(2)/bfr_plane_coeff(3))*TU(:,2)+(bfr_plane_coeff(4)/bfr_plane_coeff(3)));
Z2=reshape(Z1,[rr cc]);

figure;
h8=surf(y_fpiR,x_fpiR,BDZ);
set(h8,'edgecolor','none');
hold on;
mesh(y_fpiR,x_fpiR,Z2);
Z3=Z2;
Z3(BD==0)=0;

%Planar differences
Zdiff=BD-Z3;
pb_corrected_fpiR=Zdiff;
pb_corrected_fpiR(pb_corrected_fpiR==0)=NaN;
figure;
h9=surf(y_fpiR,x_fpiR,pb_corrected_fpiR);
set(h9,'edgecolor','none');
end

